#!/bin/sh
#
# ptexlive -- Japanese patches for TeX Live
#  Nobuyuki Tsuchimura
#

#
# Don't edit this file directly. See 'ptexlive.sample'.
#

ISO_DIR=/media/TeXLive2008

TEXLIVE_DIR=/usr/local/texlive/2008
# TEXLIVE_DIR=$ISO_DIR

PREFIX=/usr/local/texlive/p2008

TMP_PREFIX=/var/tmp/ptexlive2008
# TMP_PREFIX=/dev/shm/ptexlive2008

TEXMFDIST=
# TEXMFDIST=/usr/local/share/texmf-dist

TEXSRC_EXTRACTED=
# TEXSRC_EXTRACTED=/tmp/ptexlive/build

STRIP=no
# STRIP=yes

MAKE=make
# MAKE=gmake

PATCH=patch
# PATCH=gpatch

MD5=md5
# MD5=md5sum
# MD5=gmd5sum
# MD5="digest -a md5"
# MD5=none

LZMA="lzmadec <"
# LZMA="7za x -so"
# LZMA="lzma -cd"

SYSTEM_NKF=yes
# SYSTEM_NKF=no

KANJI_CODE=UTF8
# KANJI_CODE=EUC
# KANJI_CODE=SJIS
# KANJI_CODE=JIS

test "$PRINT_CFG" != "yes" && \
echo "------------------------------------------------------------------------"

conf_option() {
    CONF_OPTION="$CONF_OPTION $@"
}

### auto detect
gmake   --version > /dev/null 2>&1 && MAKE=gmake
gpatch  --version > /dev/null 2>&1 && PATCH=gpatch
digest  -l        > /dev/null 2>&1 && MD5="digest -a md5"
gmd5sum --version > /dev/null 2>&1 && MD5=gmd5sum
md5sum  --version > /dev/null 2>&1 && MD5=md5sum
md5sum  -h        > /dev/null 2>&1 && MD5=md5sum
7za               > /dev/null 2>&1 && LZMA="7za x -so"
lzma --version    > /dev/null 2>&1 && LZMA="lzma -cd"

### constant
CP="cp -pf"
MV="mv"
LN="ln -sf"
RM="rm -f"
MKDIR="mkdir -p"
RMDIR="rmdir -p"

MKTEXLSR="texconfig-sys rehash"
UPDMAP="updmap-sys"
PTEXLIVE_TMP=ptexlive-tmp.$$

# usage: tarcp src-dir dist-dir
tarcp() {
    echo "[copying]    $1"
    echo "          -> $2"
    if test ! -d "$1"; then echo "'$1' isn't a directory"; exit 1; fi
    test -d "$2" || $MKDIR "$2"
    (cd "$1" && tar cf - .) | (cd "$2" && tar xf -) || exit
}

# usage: tarx hoge.tar.gz dist-dir
tarx() {
    echo "[extracting] $1"
    echo "          -> $2"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    test -d "$2" || $MKDIR "$2"
    case "$1" in
	*.zip)  unzip -qo "$1" -d "$2" || exit 1;;
	*.lzh)  lha ew="$2" "$1" || exit 1;;
	*.gz)   gzip  -cd  "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
	*.bz2)  bzip2 -cd  "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
	*.lzma) eval $LZMA "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
	*.tar)  cat        "$1" | (umask 0; cd "$2"; tar xf -) || exit 1;;
	*)      echo "Unknown compression type: $1"; exit 1;;
    esac
}

# usage: zpatch hoge.patch.gz strip-num dist-dir
zpatch() {
    echo "[patching]   $1"
    if test ! -f "$1"; then echo "'$1' doesn't exist"; exit 1; fi
    case "$1" in
	*.gz)   gzip  -cd  "$1" | $PATCH -p$2 -s -d "$3" || exit 1;;
	*.bz2)  bzip2 -cd  "$1" | $PATCH -p$2 -s -d "$3" || exit 1;;
	*.lzma) eval $LZMA "$1" | $PATCH -p$2 -s -d "$3" || exit 1;;
	*)      cat        "$1" | $PATCH -p$2 -s -d "$3" || exit 1;;
    esac
}

# usage: perlprint one-line-script target-file
perlprint() {
    echo "[rewriting]  $2"
    if test ! -f "$2"; then echo "'$2' doesn't exist"; exit 1; fi
    perl -pi -e "$1" "$2" || exit 1
}

# usage: perlnoprint one-line-script target-file
perlnoprint() {
    echo "[rewriting]  $2"
    if test ! -f "$2"; then echo "'$2' doesn't exist"; exit 1; fi
    perl -ni -e "$1" "$2" || exit 1
}

# usage: nkfjis target-file
#nkfjis() {
#    for f in "$*"; do
#	echo "[to JIScode] $f"
#	nkf -jd --overwrite $f || exit 1
#    done
#}

# usage: nkfutf8 target-file
nkfutf8() {
    for f in $*; do
	echo "[to UTF-8]   $f"
	nkf -wd --overwrite $f || exit 1
    done
}

# usage: nkfutf8n target-file
nkfutf8n() {
    for f in $*; do
	echo "[to UTF-8N]  $f"
	nkf -w8d --overwrite $f || exit 1
    done
}

# usege: eightbit2hex $TEXMF path name
# It converts 8bit character into '^^??' form,
# which is convenient for Japanese pTeX 3.1.8 and latter.
# '^^??' form prevents both "platex --kanji=euc" and "platex --kanji=sjis"
# from occurring errors.
eightbit2hex() {
    echo "[to hex]     $1/$2/$3"
    test -d "$1/p$2" || $MKDIR "$1/p$2"
    if   test -f "$1/$2/$3";   then DIR="$1"
    elif test -z "$TEXMFDIST"; then DIR="$1-dist"
    else                            DIR="$TEXMFDIST"
    fi
    perl -p -e 's/([\x80-\xff])/sprintf("^^%x", ord $1)/eg' \
	< "$DIR/$2/$3" > "$1/p$2/$3" || exit 1
}

# usage: distcp $TEXMF path name
distcp() {
    echo "[copying]    $1/$2/$3"
    test -d "$1/$2" || $MKDIR "$1/$2"
    if test -z "$TEXMFDIST"; then
	$CP    "$1-dist/$2/$3" "$1/$2/$3" || exit 1
    else
	$CP "$TEXMFDIST/$2/$3" "$1/$2/$3" || exit 1
    fi
}

# usage: lndir src-dir dist-dir name
lndir() {
    test -d "$2" || $MKDIR "$2"
    test -h "$2/$3" && $RM "$2/$3"
    $LN "$1" "$2/$3"
}

# usage: md5check < md5sum.file
md5check() {
    test "$MD5" = "none" && exit 0 # no check
    ERROR=0
    while read SUM FILE; do
	if test "`$MD5 < $FILE | awk '{print $1}'`" != $SUM; then
	    echo "$FILE: FAILED"; ERROR=1
	fi
    done
    if test $ERROR -ne 0; then
	echo "md5check: WARNING: checksums did NOT match"
	exit 1
    fi
}

shouldnotexist() {
    if test -f "$1" -o -d "$1"; then
	echo ""
	echo "'$1' already exists."
	echo "Please 'rm -rf $1'. ('make distclean' maybe convenient)."
	echo ""
	exit 1
    fi
}

enoughspace() {
    DISKFREE=`df -k "$1" | tail -1 | awk '{print $4}'`
    if test $DISKFREE -le $2; then
	echo ""
	echo "We need about $2 Kbyte free disk space."
	echo "'$1' has only $DISKFREE Kbyte free."
	echo -n "Continue? (yes/No) "
	read REPLY
	case $REPLY in
	    yes) ;;
	    *) exit 1;;
	esac
    fi
}

root_check() {
    if test "$UID" = 0; then
	echo ""
	echo "You are root."
	echo "It is RECOMMENDED to execute by a user."
	echo "Executing by root may cause SERIOUS DAMAGE for your system."
	echo -n "Are you sure to execute by root AT YOUR OWN RISK? (yes/NO) "
	read REPLY
	case $REPLY in
	    yes) ;;
	    *) exit 1;;
	esac
    fi
}

# usage: necessitycommand command arg1 arg2 ...
necessity_command() {
    echo "[searching]  $1 	-- `which $1`"
    $@ > /dev/null 2>&1 && return
    echo ""
    echo "You need '$1' command."
    echo ""
    exit 1
}

# usage: read_cfg file-name
read_cfg() {
    if test -f  $1; then
	echo "[reading]    $1"
	.  $1
	CFG=yes
	if test "$PRINT_CFG" = "yes"; then
	    perl -ne 's/\s*#.*//; if (/^$/) {print unless $empty; $empty=1}
		else {print; $empty=0}' < $1
	    echo "------------------------------------------------------------------------"
	fi
    fi
}

read_cfg  ./ptexlive.cfg
read_cfg ../ptexlive.cfg
read_cfg ../ptexlive.cfg.`hostname | sed -e 's/\..*//'`
if test -z "$CFG"; then
    cat <<EOF
Error: No "ptexlive.cfg" was found.
Please read "ptexlive.sample" or "ptexlive.sample.en".
------------------------------------------------------------------------
EOF
    exit 1
fi

# remove space in PATH (especially for Cygwin)
PATH=`echo $PATH | tr -d ' '`
# remove install-dir from PATH (for auto detect)
PATH=`echo $PATH | sed -e "s|$PREFIX/bin:||g"`
# detect if system nkf supports UTF-8
nkf --help 2>&1 | grep guess > /dev/null || SYSTEM_NKF=no

echo ${SRC_TAR:=$ISO_DIR/source/texlive-20080816-source.tar.lzma} > /dev/null
SRC=${TEXSRC_EXTRACTED:-$TMP_PREFIX/texlive-20080816-source}
ARCH=`ls $SRC/inst/bin/ 2> /dev/null`
           PATH=$SRC/inst/bin/$ARCH:$PATH
LD_LIBRARY_PATH=$SRC/inst/lib/$ARCH:$LD_LIBRARY_PATH
      TEXMFMAIN=$SRC/inst/texmf
TEXMF=$TEXMFMAIN
export PATH LD_LIBRARY_PATH TEXMFMAIN

unset TEXINPUTS
unset PTEX_KANJI_ENC
PTEX_IN_FILTER=no
export PTEX_IN_FILTER
#echo "ARCH=$ARCH"
