#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

. ./common.sh

## arg check
if test -z "$1"; then
cat <<EOF
usage : $0 {install,refresh,uninstall,distclean}
ex.:    $0 install refresh
EOF
exit 1
fi

confirm() {
    echo -n "$1 (yes/No) "
    read REPLY <&2
    case $REPLY in
	y*|Y*) true;;
	*) echo "Aborted."; exit 0;;
    esac
}

while [ -n "$1" ]; do
    case "$1" in
	distclean)
if test -d "$TMP_PREFIX"; then
    confirm "Removing '$TMP_PREFIX' ok?"
    rm -rf "$TMP_PREFIX"
fi
;;
	uninstall)
confirm "Removing '$PREFIX' ok?"
if test -d "$PREFIX/texmf-local"; then
    echo "Customized files '$PREFIX/texmf-local' are found."
    confirm "*DANGEROUS* Are you surely remove them?"
fi
rm -rf "$PREFIX"
;;
	install)
echo "copying files '$TMP_PREFIX' -> '$PREFIX' ..."
test -d "$PREFIX" && confirm "'$PREFIX' is found. Overwrite?"
$MKDIR $PREFIX || exit
(cd $SRC/inst && tar cf - bin lib include share texmf texmf-dist tlpkg) \
    | (cd $PREFIX && tar xf -) || exit
test "$UID" = 0 && chown -R 0:0 $PREFIX
cat <<EOF
------------------------------
'ptexlive' was installed.

for sh/bash user
export PATH=$PREFIX/bin/$ARCH:\$PATH

for csh/tcsh user
setenv PATH $PREFIX/bin/$ARCH:\$PATH

To uninstall
make uninstall
(or 'rm -rf $PREFIX')
------------------------------
EOF
;;
	refresh) echo "finishing ..."
           PATH=$PREFIX/bin/$ARCH:$PATH
LD_LIBRARY_PATH=$PREFIX/lib/$ARCH:$LD_LIBRARY_PATH
      TEXMFMAIN=$PREFIX/texmf
export PATH LD_LIBRARY_PATH TEXMFMAIN

$MKTEXLSR 2> /dev/null || exit
$UPDMAP   2> /dev/null || exit
(fmtutil-sys --all 2>&1) > /dev/null
# You can check if "$TMP_PREFIX" is not included in files under $PREFIX.
# grep $TMP_PREFIX -l -r $PREFIX || true
;;
	*) echo "Unknown option $1";;
    esac
    shift
done
