#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check

BIN=$SRC/inst/bin/$ARCH
test -z "$PXDVI" -a "$XDVI" = "echo" && PXDVI=echo
test -z "$DVIPS"  && DVIPS=$BIN/dvips
test -z "$DVIPDF" && DVIPDF=$BIN/dvipdfm
test -z "$XDVI"   && XDVI="$BIN/xdvi -debug 8"
test -z "$PSPDF"  && PSPDF="ps2pdf -dNOKANJI"
test -z "$PDVIPS"  && PDVIPS=$BIN/pdvips
test -z "$PDVIPDF" && PDVIPDF=$BIN/dvipdfmx
test -z "$PXDVI"   && PXDVI="$BIN/pxdvi -debug 8"

## usage: catexit hoge.log
catexit() {
    cat $1
    exit 1
}

## usage: ex command args....
ex() {
    if $@ 2> /dev/null; then return; fi
    echo "$@"
    $@
    exit 1
}

## check for shared library
#ldd $BIN/latex  | grep kpath
#ldd $BIN/platex | grep kpath

if test ! -x $BIN/kpsewhich; then
    cat <<EOF
-----------------------------
You don't have "$BIN/kpsewhich".
Did you succeed in "make"? See "log-MMDD-hhmm".

EOF
    exit 1
fi

$BIN/fmtutil-sys --byfmt platex

#if $BIN/kpsewhich platex.fmt > /dev/null; then
#    echo "dummy, ok." > /dev/null
#else
#    cat <<EOF
#-----------------------------
#We can't look up "platex.fmt".
#(1) Did you succeed in "make"? See "log-MMDD-hhmm".
#(2) Did you succeed in "make c"? (if you executed "make" step by step)
#
#EOF
#    exit 1
#fi

if $BIN/kpsewhich -progname=platex jsarticle.cls > /dev/null; then
    echo "dummy, ok." > /dev/null
else
    cat <<EOF
-----------------------------
We can't look up "jsarticle.cls".
(1) Did you succeed in "make"? See "log-MMDD-hhmm".
(2) Did you succeed in "make macro"? (if you execute "make" step by step)

EOF
    exit 1
fi

if $BIN/kpsewhich -format="cmap files" H > /dev/null; then
    echo "dummy, ok." > /dev/null
else
    cat <<EOF
-----------------------------
We can't look up CMap "H".
(1) Did you execute "make font"?
(2) Do you have ghostscript in your system?

EOF
    exit 1
fi

$MKDIR ptexlive-test-$$
cd ptexlive-test-$$

# [$TEXMF/tex/latex/base/testpage.tex]
echo "-----------------------------"
echo "[latex] test"
$BIN/latex testpage.tex <<EOF > /dev/null || catexit testpage.log
a4paper
y
EOF

ex $DVIPS  testpage.dvi
ex $DVIPDF testpage.dvi > /dev/null
ex $XDVI   testpage.dvi


# [$TEXMF/ptex/platex/jsclasses/jsclasses.dtx]
echo "-----------------------------"
echo "[platex yoko] test"
$BIN/platex jsclasses.dtx < /dev/null > /dev/null || catexit jsclasses.log
$BIN/platex jsclasses.dtx < /dev/null > /dev/null || catexit jsclasses.log

ex $PDVIPS  jsclasses.dvi
ex $PDVIPDF jsclasses.dvi
ex $PXDVI   jsclasses.dvi

# [macro/sample.tex]
echo "-----------------------------"
echo "[platex tate] test"
$BIN/platex ../macro/sample.tex < /dev/null > /dev/null || catexit sample.log

ex $PDVIPS  sample.dvi
ex $PDVIPDF sample.dvi
   $PXDVI   sample.dvi 2>&1 | grep FreeType2 && exit 1

# [$TEXMF/packages/utfsrc/test/utfsmpl.tex]
if test -f $TEXMF/packages/utfsrc/test/utfsmpl.tex; then
echo "-----------------------------"
echo "[UTF package] test"
$BIN/platex $TEXMF/packages/utfsrc/test/utfsmpl.tex \
    < /dev/null > /dev/null || catexit utfsmpl.log

ex $PDVIPDF -o utfsmpl-dvipdfmx.pdf utfsmpl.dvi
ex $PDVIPS  utfsmpl.dvi
   $PSPDF   utfsmpl.ps utfsmpl-ps2pdf.pdf
ex $PXDVI   utfsmpl.dvi
fi

exit 0

# [$TEXMF/packages/otfstable/test/otftest.tex]
if test -f $TEXMF/packages/otfstable/test/otftest.tex; then
echo "-----------------------------"
echo "[OTF package] test"
$CP ../macro/furikana.sty .
$BIN/platex $TEXMF/packages/otfstable/test/otftest.tex \
    < /dev/null > /dev/null || catexit otftest.log

ex $PDVIPDF -o otftest-dvipdfmx.pdf otftest.dvi
ex $PDVIPS  otftest.dvi
   $PSPDF   otftest.ps otftest-ps2pdf.pdf
ex $PXDVI   otftest.dvi
fi

# [babel/babeltestJIS.tex]
if kpsewhich -progname=platex japanese.dtx > /dev/null; then
echo "-----------------------------"
echo "[Babel + ptex] test"
$BIN/platex ../babel/babeltestJIS.tex \
    < /dev/null > /dev/null || catexit babeltestJIS.log

ex $PDVIPS  babeltestJIS.dvi
ex $PDVIPDF babeltestJIS.dvi
ex $PXDVI   babeltestJIS.dvi
fi

# -dNOKANJI check for dvipdfmx
echo "-----------------------------"
echo "[-dNOKANJI] test"
cat <<EOF > dNOKANJI.tex
\documentclass[43pt]{jsarticle}
\setlength{\headsep}{-3em}
\usepackage{graphicx}
\begin{document}
\noindent {\tiny If char and EPS looks similar, OK.}

\noindent
Char: {\Huge ぱぴぷ} \newline
\raisebox{3em}{EPS:~}
\includegraphics[clip,width=0.7\linewidth]{`pwd`/dNOKANJI.eps}
\end{document}
EOF

cat <<EOF > dNOKANJI.eps
%!PS-Adobe-2.0
%%BoundingBox: 20 100 330 308
%%BeginProlog
/OurCharSet findfont 12 scalefont setfont
(a) stringwidth pop /mp_a_x exch def
%%EndProlog
save
gsave
560 11 mp_a_x mul div 306 18 div scale
4 7 translate 552 560 div 16 36 div scale
/Ryumin-Light-H findfont 14 scalefont setfont
0 13 moveto <2451> show
2 mp_a_x mul 13 moveto <2454> show
4 mp_a_x mul 13 moveto <2457> show
0 0 moveto <245a> show
2 mp_a_x mul 0 moveto <245d> show
4 mp_a_x mul 0 moveto <396c> show
grestore
restore
showpage
EOF

nkfutf8n    dNOKANJI.tex > /dev/null
$BIN/platex dNOKANJI.tex < /dev/null > /dev/null || catexit dNOKANJI.log
ex $PDVIPS  dNOKANJI.dvi
ex $PDVIPDF dNOKANJI.dvi
if test `wc -c < dNOKANJI.pdf` -gt 10000; then
    cat <<EOF
Warning: 'gs' seem to embed Japanese fonts in spite of '-dNOKANJI' option.
Check gs options in $TEXMF/dvipdfmx/dvipdfmx.cfg.
We may need some additional patches for ghostscript.
EOF
fi

# CVE-2007-0104 check for pdflatex
echo "-----------------------------"
echo "[CVE-2007-0104] test"
cat <<EOF > xpdf.tex
\documentclass{article}
\usepackage{graphicx}
\begin{document}
\includegraphics{../security/MOAB-06-01-2007.pdf}
\end{document}
EOF
if ! $BIN/pdflatex xpdf.tex 2>&1 | grep "recursive calls" > /dev/null; then
    echo "CVE-2007-0104 is not fixed."
    exit 1
fi

cat <<EOF
-----------------------------

Congratulations! TeX environment seems to work properly.

EOF
