#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#
# pTeX に各言語のハイフン定義ファイルを読み込ませ、
# Babel マクロパッケージをちゃんと使えるようにします。
#
# http://www2.tba.t-com.ne.jp/ing/ing/gcinst3g3sj.txt
# の内容を踏襲しましたが、簡略化して実行しています。
# つまり、なるべく TeX Live 2007 付属のファイルを利用し、
# $TEXMF-dist/ 以下のファイルをスクリプトで変換する場合は、
# 同名のファイルを $TEXMF/ 以下につくり、
# なるべく language.dat を変更しないようにしています。

. ./common.sh
root_check

test -f $TEXMF/ptex/platex/config/hyphen.cfg && \
     mv $TEXMF/ptex/platex/config/hyphen.cfg \
        $TEXMF/ptex/platex/config/hyphen.cfg.ptex

### extra files (shhyphl.tex, elhyphen, teubner, etc.)
#tarx babel/ptexlive-babel.tar.gz $TEXMF

### (1) bug fix of Babel
## usorbian
distcp $TEXMF tex/generic/babel usorbian.ldf
perlprint 's/^(\\addto\\extrasusorbian\{\\babel\@savevariable\{\\lccode`\\\^\^Y\}%)$/%\1/g;
	s/^(  \\lccode\`\\\^\^Y\`\\\^\^Y})$/%\1/g' \
     $TEXMF/tex/generic/babel/usorbian.ldf

## icelandic
distcp $TEXMF tex/generic/babel icelandic.ldf
perlprint 's/(decimalsep|thousandsep)/ice$1/g' \
       $TEXMF/tex/generic/babel/icelandic.ldf

## welsh
echo "welsh		cyhyph.tex" >> $TEXMF/tex/generic/config/language.dat

### (2) change encoding (to coexist with Japanese EUC, SJIS)
## ukrainian as OT2 encoding
perlprint 's/^(ukrainian\s+ukrhyph.tex)/%! \1/g;
           s/^%! (ukrainian\s+ukrhyph.ot2)/\1/g' \
       $TEXMF/tex/generic/config/language.dat
distcp $TEXMF tex/generic/ukrhyph ukrhyph.tex
perlprint 's/(\\patterns\{ c8h d8j k8h l8j n8j s8h s8h8c8h t8s x8q y8a y8u z8h \})/%\1/g' \
       $TEXMF/tex/generic/ukrhyph/ukrhyph.tex

## russian as OT2 encoding
distcp $TEXMF tex/generic/ruhyphen ruhyphen.tex
perlprint 's/^(\\def\\Encoding\{t2a\})/%\1/g;
           s/%(\\def\\Encoding\{ot2\})/\1/g' \
       $TEXMF/tex/generic/ruhyphen/ruhyphen.tex
distcp $TEXMF tex/generic/ruhyphen koi2ot2.tex
perlprint 's/^%(\\patterns)/\1/g' \
       $TEXMF/tex/generic/ruhyphen/koi2ot2.tex
distcp $TEXMF tex/generic/ruhyphen ruhyphal.tex
perlprint 's/^(2\xcb1\xc82)$/%\1/g;
           s/^(\xd31\xc82)$/%\1/g;
           s/^(4\xd41\xd32)$/%\1/g;
           s/^(2\xdb1\xde)$/%\1/g;
           s/^(\xd9\xd52)$/%\1/g' \
       $TEXMF/tex/generic/ruhyphen/ruhyphal.tex

### (3) convert 8bit character into ^^?? form
eightbit2hex $TEXMF tex/generic/ukrhyph  ukrhypmp.tex
eightbit2hex $TEXMF tex/generic/ruhyphen ruhyphen.tex
eightbit2hex $TEXMF tex/generic/ruhyphen catkoi.tex
eightbit2hex $TEXMF tex/generic/ruhyphen koi2ot2.tex
eightbit2hex $TEXMF tex/generic/ruhyphen ruhyphal.tex
eightbit2hex $TEXMF tex/generic/ruhyphen cyryoal.tex
eightbit2hex $TEXMF tex/generic/babel    icelandic.ldf

### japanese style
tarx babel/japanese.zip $TEXMF/ptex/generic/babel/japanese
(cd $TEXMF/ptex/generic/babel/japanese || exit
platex --kanji=jis japanese.ins || exit
$MKDIR $TEXMF/doc/japanese || exit
$MV README sample.tex sample.pdf $TEXMF/doc/japanese || exit
$RM japanese.log || exit
)

## update fmt
$MKTEXLSR || exit
fmtutil-sys --byfmt latex  || exit
fmtutil-sys --byfmt platex || exit

## post
chmod -R u+w  $TEXMF || exit
chmod -R og-w $TEXMF || exit
echo ""
