#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check
MAP=$TEXMF/fonts/map/dvipdfm/ptexlive

## start
$MV $TEXMF-dist $TEXMF-dist.install || exit
$MV $TEXMF      $TEXMF.install      || exit
tarcp $TEXLIVE_DIR/texmf $TEXMF     || exit
chmod -R u+rw            $TEXMF     || exit
tarcp $TEXMF.install     $TEXMF     || exit

$LN $TEXLIVE_DIR/tlpkg      $TEXMF/.. || exit
$LN $TEXLIVE_DIR/texmf-dist $TEXMF/.. || exit


## for ptex
tarx archive/ptex-texmf-2.5.tar.gz $TEXMF
# http://oku.edu.mie-u.ac.jp/~okumura/texfaq/qa/49084.html
#$MV $TEXMF/ptex-texmf/ptex $TEXMF/ptex-texmf/tex || exit
# text in UTF-8
$MV $TEXMF/ptex-texmf/COPYRIGHT.jis $TEXMF/ptex-texmf/doc/ptex/COPYRIGHT.utf8 || exit
$MV $TEXMF/ptex-texmf/COPYRIGHT     $TEXMF/ptex-texmf/doc/ptex/ || exit
$MV $TEXMF/ptex-texmf/Changes.txt   $TEXMF/ptex-texmf/doc/ptex/ || exit
$MV $TEXMF/ptex-texmf/README.txt    $TEXMF/ptex-texmf/doc/ptex/ || exit
nkfutf8                             $TEXMF/ptex-texmf/doc/ptex/*
nkfutf8                             $TEXMF/ptex-texmf/doc/jbibtex/doc-ascii/*
nkfutf8                             $TEXMF/ptex-texmf/ptex/platex/base/*.txt
nkfutf8n                            $TEXMF/ptex-texmf/jbibtex/bib/jxampl.bib
nkfutf8n                            $TEXMF/ptex-texmf/jbibtex/bst/*
nkfutf8n                            $TEXMF/ptex-texmf/fonts/source/ptex/*.pl
nkfutf8n                            $TEXMF/ptex-texmf/ptex/plain/base/kinsoku.tex
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/*.tex
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/*.dtx
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/*.cls
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/nidanfloat.sty
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/plcls.ins
nkfutf8n                            $TEXMF/ptex-texmf/ptex/platex/base/pldefs.ltx
$MV $TEXMF/ptex-texmf/jbibtex       $TEXMF/ptex-texmf/pbibtex
tarcp    $TEXMF/ptex-texmf $TEXMF
$RM -r   $TEXMF/ptex-texmf || exit

eightbit2hex $TEXMF tex/latex/ltxmisc url.sty

## for fmtutil
cat <<EOF > $TEXMF/fmtutil/format.ptex.cnf || exit
# ------------------------------------------------------------------
# Japanese pTeX:
ptex		ptex		-		--kanji=default ptex.ini
platex		ptex		language.dat	--kanji=default platex.ini
EOF

# (ad hoc fix, help me.)
cat $TEXMF/fmtutil/format.ptex.cnf >> $TEXMF/web2c/fmtutil.cnf || exit
texlinks

## for updmap
cat <<EOF >> $TEXMF/web2c/updmap.cfg || exit

# kanjiEmbed {noEmbed|hiragino|kozuka|morisawa|ipa-ttf|ipa-otf|etc..}
kanjiEmbed noEmbed

# Japanese font map
KanjiMap ptex-@kanjiEmbed@.map
#! KanjiMap utf-@kanjiEmbed@.map
#! KanjiMap otf-@kanjiEmbed@.map
#! KanjiMap otf-cktx.map
KanjiMap morisawa.map

EOF

$MKDIR $MAP || exit
cat <<EOF > $MAP/ptex-noEmbed.map || exit
%%
%% ASCII pTeX
%%

rml	H	min
rmlv	V	min
gbm	H	goth
gbmv	V	goth
EOF
$CP $MAP/ptex-noEmbed.map $MAP/ptex-ipa-ttf.map
$CP $MAP/ptex-noEmbed.map $MAP/ptex-ipa-otf.map
$CP $MAP/ptex-noEmbed.map $MAP/ptex-hiragino.map
$CP $MAP/ptex-noEmbed.map $MAP/ptex-kozuka.map
$CP $MAP/ptex-noEmbed.map $MAP/ptex-morisawa.map
perlprint "s/min/\!Ryumin-Light/g;
	  s/goth/\!GothicBBB-Medium/g;"   $MAP/ptex-noEmbed.map
perlprint "s/min/ipam.ttf/g;
	  s/goth/ipag.ttf/g;"             $MAP/ptex-ipa-ttf.map
perlprint "s/min/ipam.otf/g;
	  s/goth/ipag.otf/g;"             $MAP/ptex-ipa-otf.map
perlprint "s/min/HiraMinPro-W3/g;
	  s/goth/HiraKakuPro-W6/g;"       $MAP/ptex-hiragino.map
perlprint "s/min/KozMinPro-Regular-Acro.otf/g;
	  s/goth/KozGoStd-Regular.otf/g;" $MAP/ptex-kozuka.map
perlprint "s/min/A-OTF-RyuminPro-Light.otf/g;
	  s/goth/A-OTF-GothicBBBPro-Medium.otf/g;" $MAP/ptex-morisawa.map

cat <<EOF > $MAP/morisawa.map || exit
%%
%% Morisawa
%%
ryumin-l    H	Ryumin-Light
ryumin-l-v  V	Ryumin-Light
gtbbb-m     H	GothicBBB-Medium
gtbbb-m-v   V	GothicBBB-Medium
futomin-b   H	FutoMinA101-Bold
futomin-b-v V	FutoMinA101-Bold
futogo-b    H	FutoGoB101-Bold
futogo-b-v  V	FutoGoB101-Bold
jun101-l    H	Jun101-Light
jun101-l-v  V	Jun101-Light
EOF

## for jis/jisg/morisawa
tarx archive/jis.tar.gz $PTEXLIVE_TMP
$CP $PTEXLIVE_TMP/jis/tfm/ptex/* $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTEXLIVE_TMP/jis/vf/*       $TEXMF/fonts/vf/ptex/  || exit

tarx archive/morisawa.tar.gz $PTEXLIVE_TMP
$CP $PTEXLIVE_TMP/morisawa/tfm/dvips/* $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTEXLIVE_TMP/morisawa/tfm/ptex/*  $TEXMF/fonts/tfm/ptex/ || exit
$CP $PTEXLIVE_TMP/morisawa/vf/*        $TEXMF/fonts/vf/ptex/  || exit

## replace same vf file with symbolic link
(cd $TEXMF/fonts/vf/ptex || exit
if cmp min10.vf goth10.vf > /dev/null; then
    echo "  Do nothing because of bug of 'cmp'."
else
    for f in *10.vf; do
	if test ! -h $f; then
	    for g in *min*.vf *goth*.vf; do
		if test ! -h $g -a $f != $g; then
		    cmp $f $g > /dev/null && ($RM $g; $LN $f $g)
		fi
	    done
	fi
    done
fi
)

## doc
$MKDIR $TEXMF/doc/ptexlive || exit
$CP README* ChangeLog* LICENSE $TEXMF/doc/ptexlive || exit


## post
$RM -r $PTEXLIVE_TMP || exit
(cd $TEXMF || exit
chmod -R og-w .
# useless files
find . -type d -name CVS        -exec echo [removing]   '{}' \;
find . -type d -name CVS        -exec $RM -r            '{}' \;
find . -type f -name .cvsignore -exec echo [removing]   '{}' \;
find . -type f -name .cvsignore -exec $RM               '{}' \;
)
echo ""

# updmap
$MKTEXLSR 2> /dev/null || exit
$UPDMAP --nomkmap --syncwithtrees 2> /dev/null || exit
if test -f $SRC/inst/texmf-config/web2c/updmap.cfg; then
    $MV $SRC/inst/texmf-config/web2c/updmap.cfg $SRC/inst/texmf/web2c/ || exit
fi

## check
cat md5sum/texmf | (cd $TEXMF; md5check) && exit
cat <<EOF

$0: Some processes were performed improperly.
Check if you have GNU patch.
Some environment variables (TEXMF, LD_LIBRARY_PATH, etc) may make side effect.

EOF
exit 1
