#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check

xdvi_check() {
    if test ! -f $SRC/tmp/texk/xdvik/Makefile && test "$XDVI" != "echo"; then
	cat <<-EOF
	-----------------------------
	We are NOT going to compile xdvi.  We have two choices.
	1. (with xdvi)    Check if we have X11 headers.
	2. (without xdvi) Set XDVI=echo in "ptexlive.cfg" to omit xdvi test.
	
	EOF
	exit 1
    fi
}

cd $SRC || exit
TL_MAKE=$MAKE ./Build --with-ptexenc=$KANJI_CODE $CONF_OPTION || exit

if test "$STRIP" = "yes"; then
    strip  $TMP_PREFIX/bin/* 2> /dev/null
    strip  $TMP_PREFIX/lib/libkpathsea.* \
	   $TMP_PREFIX/lib/libptexenc.* 2> /dev/null
    ar -ts $TMP_PREFIX/lib/libkpathsea.* \
	   $TMP_PREFIX/lib/libptexenc.* 2> /dev/null
fi

# we can't excute following 2 lines because $ARCH is empty now.
#$MKTEXLSR || exit
#$UPDMAP 2> /dev/null || exit
date

cat <<EOF
------------------------------
'ptexlive' binary was installed temporary.
(You should need extra macros and settings of Japanese fonts
 via 'make macro' and 'make font'.)
------------------------------
EOF

cat <<EOF > /dev/null
A WIZARD of UNIX can use the temporary TeX system by following setting.
In most case 'make install' is recommended.

(for sh/bash user)
export            PATH=$SRC/inst/bin/$ARCH:\$PATH
export LD_LIBRARY_PATH=$SRC/inst/lib/$ARCH:\$LD_LIBRARY_PATH
export       TEXMFMAIN=$TEXMFMAIN

(for csh/tcsh user)
setenv            PATH $SRC/inst/bin/$ARCH:\$PATH
setenv LD_LIBRARY_PATH $SRC/inst/lib/$ARCH:\$LD_LIBRARY_PATH
setenv       TEXMFMAIN $TEXMFMAIN
------------------------------

EOF
