#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

. ./common.sh
root_check

if test -z "$TEXSRC_EXTRACTED"; then
    shouldnotexist $SRC
    $MKDIR $SRC || exit
fi

GSNOEMBED="-dNOKANJI -c '.setpdfwrite << /NeverEmbed [/Courier /Courier-Bold /Courier-Oblique /Courier-BoldOblique /Helvetica /Helvetica-Bold /Helvetica-Oblique /Helvetica-BoldOblique /Times-Roman /Times-Bold /Times-Italic /Times-BoldItalic /Symbol /ZapfDingbats /Ryumin-Light /GothicBBB-Medium] >> setdistillerparams'"

## start
test -z "$TEXSRC_EXTRACTED" && tarx $SRC_TAR $TMP_PREFIX
# bug fix (no man5dir)
perlprint 'print "\t\$(SHELL) \$(top_srcdir)/../mkinstalldirs \$(man5dir)\n" if /man5dir/' $SRC/texk/web2c/Makefile.in

# fix dvipdfmx segfault
zpatch archive/dvipdfmx-20090502-bufferover.patch 1 $SRC/texk/dvipdfmx
# update xdvik
#zpatch archive/xdvik-22.84.14-texlive2007.diff.gz 1 $SRC

# fix for sparc64/amd64
# http://www.mail-archive.com/dev-luatex@ntg.nl/msg00120.html
zpatch archive/patch-libs_lua51_lcoco_c 0 $SRC
zpatch archive/patch-libs_lua51_lcoco_h 0 $SRC

# fix getline
zpatch archive/web2c2009-getline.patch 3 $SRC
for f in \
    texk/web2c/mpware/mpto.c \
    texk/afm2pl/afm2pl.c \
    texk/dvi2tty/dvistuff.c \
    texk/dvipsk/afm2tfm.c \
    texk/ttf2pk/newobj.c \
    texk/ttf2pk/newobj.h \
    texk/ttf2pk/parse.c \
    libs/lua51/ldebug.h \
    libs/lua51/lvm.c \
    libs/lua51/print.c \
    libs/lua51/ldebug.c \
    utils/t1utils/t1asm.c; do
  perlprint 's/getline/texlive_getline/g' $SRC/$f
done

# Fix usage of uninitialized variable (imported from FC4)
#zpatch archive/tetex-3.0-dcb314.patch  1 $SRC
# Fix cm-super bug on dvipdfm.map
#zpatch archive/updmap-cmsuper.patch     1 $SRC

# Work around of bug of ls (GNU coreutils-6.x (x=0..7))
# http://lists.gnu.org/archive/html/bug-coreutils/2007-01/msg00005.html
$LN md5sum $PTEXLIVE_TMP
ls -LR . | grep "$PTEXLIVE_TMP:" > /dev/null \
    || perlprint 's/LRa/LRat/' $SRC/texk/kpathsea/mktexlsr
$RM $PTEXLIVE_TMP

# epstopdf no embed fonts
#perlprint "s/OutputFilename -/OutputFilename \\\$GSNOEMBED -/;
#	print \"### no embed fonts\nmy \\\$GSNOEMBED=\\\"$GSNOEMBED\\\";\n\n\"
#	if /option BoundingBox types/" \
#    $SRC/texk/tetex/epstopdf

# add --nostop option: don't stop even if a map file is not found
zpatch archive/updmap-nostop.patch     3 $SRC/texk/tetex

## use TEXMFMAIN for TEXMFDIST etc. instead of absolute path
#perlprint 's/\@texmf\@-/\$TEXMFMAIN-/g' \
#    $SRC/texk/kpathsea/texmf.in
#perlprint 'print "#" if /echo .*TEXMF(LOCAL|DIST|%g)/' \
#    $SRC/texk/kpathsea/Makefile.in
## don't rewrite VARTEXFONTS
#perlprint 's/TEXMFCNF/\\(TEXMFCNF\\|VARTEXFONTS\\)/g' \
#    $SRC/selfautofix

# if TEXMFDIST is specified
if test -n "$TEXMFDIST"; then
    perlprint "s|^(TEXMFDIST) = .*|\1 = $TEXMFDIST|g" \
	$SRC/texk/kpathsea/texmf.cnf
fi

## for pTeX
tarx archive/ptex-src-3.1.*.tar.gz $SRC/texk/web2c
$MV $SRC/texk/web2c/ptex-src-* $SRC/texk/web2c/ptexdir || exit

## for mendexk
tarx archive/mendexk2.6?.tar.gz $SRC/texk
$MV $SRC/texk/mendexk* $SRC/texk/mendexk || exit

## for makejvf
tarx archive/makejvf-1.1a.tar.gz $SRC/texk
$MV $SRC/texk/makejvf* $SRC/texk/makejvf || exit

## for jmpost
#tarx archive/jmpost-0.04b.tar.gz $SRC/texk/web2c/ptex
#$MV $SRC/texk/web2c/ptex/jmpost-* $SRC/texk/web2c/ptex/jmpost || exit
#perlprint 's/mpost\)/mpost|jmpost\)/g' $SRC/texk/tetex/fmtutil 
#perlprint 'print "MPXCOMMAND.jmpost = pmakempx\n" if /MPXCOMMAND/' \
#    $SRC/texk/kpathsea/texmf.in

# for ptexenc library
tarx archive/ptexenc-*.tar.lzma $SRC/texk
$MV $SRC/texk/ptexenc-* $SRC/texk/ptexenc || exit
(cd $SRC/texk; . ./ptexenc/patches/texlive2008.sh) || exit
##libdepend:perlprint 's|(0:0 \$\(objects\))|\1 \$(kpathsea) \$(LIBS)|' $SRC/texk/ptexenc/Makefile.in

## nkf
NKFOPT=-j; test "$KANJI_CODE" = "UTF8" && NKFOPT=-w
if test "$SYSTEM_NKF" = "no"; then
    tarx archive/nkf-2.0.9.tar.gz $SRC/texk
    $MV $SRC/texk/nkf-* $SRC/texk/nkf || exit
    zpatch archive/nkf-2.0.9-autoconf.patch.gz 1 $SRC/texk/nkf
fi
perlprint 's/kpathsea ptexenc/kpathsea ptexenc nkf/g' $SRC/texk/configure
perlprint 's/ptexenc web2c/ptexenc nkf web2c/g'       $SRC/texk/Makefile.in
cat <<EOF >> $SRC/texk/kpathsea/texmf.cnf

% for ptex filter
PTEX_IN_FILTER = nkf $NKFOPT
EOF

# for Japanese font setting
zpatch archive/updmap-live2008-4b.diff 3 $SRC/texk/tetex
# for UTF/OTF package
zpatch archive/omegaware-texlive2008.patch 1 $SRC

## for dvipdfmx
perlprint "s/ cid-x.map\$/ kanjix.map/g;
	s|^%(D  \"gs .*%o) (%i .*\")|\1 $GSNOEMBED -f \2|" \
    $SRC/texk/dvipdfmx/data/dvipdfmx.cfg
$RM $SRC/texk/dvipdfmx/data/cid-x.map
perlnoprint "print unless /cid-x/" $SRC/texk/dvipdfmx/data/Makefile.in


## for pdvipsk
$MKDIR $SRC/texk/pdvipsk
$CP $SRC/texk/dvipsk/* $SRC/texk/pdvipsk/ 2> /dev/null
tarx archive/dvipsk-5.97-p1.7b-tl.tar.gz             $SRC/texk/pdvipsk
zpatch $SRC/texk/pdvipsk/dvipsk-5.97-p1.7b-tl.diff 1 $SRC/texk/pdvipsk

cp $SRC/texk/pdvipsk/Makefile.in $SRC/texk/pdvipsk/Makefile.in.orig
perlnoprint 's|program = dvips|program = pdvips|g;
	     s|programs = afm2tfm |programs = |g;
	     s|dvips.info||g;
	     s|install-data: \$\(program\).info|install-data:|g;
	     s|install-info.*\$\(program\).info|echo|g;
	     s|\$\(INSTALL_DATA\) \$\$i \$\(infodir\)/\$\$i||g;
	     $a=1 if /^# Info files/;
	     $a=0 if /^# TeX macros/;
	     $a=1 if /install-info/;
	     print unless $a or /udvips$/;
	     $a=0 if /else true/;' \
		 $SRC/texk/pdvipsk/Makefile.in
# noomega for pdvips
perlprint 's|^(Boolean noomega) = 0|\1 = 1|g' $SRC/texk/pdvipsk/dvips.c


## for pxdvik
tarcp $SRC/texk/xdvik    $SRC/texk/pxdvik
zpatch archive/xdvik-200?????-texlive2008.diff.gz 3 $SRC/texk/pxdvik

## freetype-2.2.1+ for pxdvi
perlprint 's/# (AUX_MODULES \+= otvalid)/\1/' $SRC/libs/freetype2/modules.cfg
## freetype fix for 64bit compiler
perlprint 's/(\s)long(\s)/$1int$2/g' $SRC/libs/freetype2/src/raster/ftraster.c
# fix for FC5
perlprint 'print "#define NeedWidePrototypes 1\n" if /limits/' \
    $SRC/texk/pxdvik/xdvi.h
# pTeX fontmap
perlnoprint "s/^ptexmap .*/ptexmap kanjix.map/; print unless /IPA/" \
    $SRC/texk/pxdvik/texmf/xdvi.cfg
# adjust X resource
cat <<EOF >> $SRC/texk/pxdvik/texmf/XDvi || exit 1


!!! ------- added by ptexlive -------

!*.shrinkFactor: 5
!*.geometry: 950x700+0+0
!*.expert: true
!*.smallPanel: false

*.editor: emacsclient --no-wait +%l %f
!*.editor: gnuclient -q +%l %f
!*.editor: gvim --servername xdvi --remote +%l %f
!*.editor: nc -noask +%l %f

*.wwwBrowser: firefox %s
!*.wwwBrowser: mozilla -remote "openURL(%s,new-tab)"
!*.wwwBrowser: mozilla -remote "openURL(%s,new-window)"
!*.wwwBrowser: htmlview %s
!*.wwwBrowser: xterm -e w3m %s
!*.wwwBrowser: xterm -e lynx %s
!*.wwwBrowser: xterm -e wget %s
EOF

for f in $SRC/texk/pxdvik/configure.in \
    $SRC/texk/pxdvik/configure; do
  perlprint  's|^(program_transform_name=s,x,)(x,)|\1p\2|;' $f
done
perlprint  's|manpage = xdvi|manpage = pxdvi|g;
	    s|.*o\$.*||g;
	    s|.*o\@.*||g;
	    s/\$\(INSTALL_DATA\).*(manext\)|pixmaps)//g;
	    s|(xdvi\.cfg)|p\1|g;
	    s|(xdvizilla)|p\1|g;'   $SRC/texk/pxdvik/Makefile.in
perlprint  's|(xdvi\.cfg)|p\1|g'    $SRC/texk/pxdvik/dvi-draw.c
$MV $SRC/texk/pxdvik/texmf/xdvi.cfg $SRC/texk/pxdvik/texmf/pxdvi.cfg || exit
$MV $SRC/texk/pxdvik/xdvizilla      $SRC/texk/pxdvik/pxdvizilla      || exit
perlprint 's|xdvi|pxdvi|g'          $SRC/texk/pxdvik/pxdvizilla


## security fix
# Don't use tmpnam() in dvipdfm. (impoted from tetex-3.0-4.FC4)
zpatch security/tetex-2.0.2-dvipdfm-security.patch 1 $SRC
# Fix gd buffer overrun CVE-2007-0455 (imported from tetex-3.0-0vl7.2)
zpatch security/tetex-3.0-CVE-2007-0455.patch      1 $SRC
# Fix xpdf integer overflow CVE-2007-3387 (impoted from tetex-3.0-35.fc6)
zpatch security/texlive2007-CVE-2007-3387.patch    1 $SRC

#exit # uncomment if 'mktemp' command doesn't exist
# Don't use PID for temporary file names in scripts. (impoted from FC4)
#zpatch security/tetex-3.0-badscript.patch          1 $SRC
## post
echo ""

## check
cat md5sum/texsrc | (cd $SRC; md5check) && exit
cat <<EOF

$0: Some processes were performed improperly.
Check if you have GNU patch.
Some environment variables (TEXMF, LD_LIBRARY_PATH, etc) may make side effect.

EOF
exit 1
