#!/bin/sh
#
# ptexlive -- Additional Japanese patches for TeX Live 2008
#  Nobuyuki Tsuchimura
#

date
echo "------------------------------------------------------------------------"
if env | grep "^TEX" | egrep -v "^(TEXINPUTS=|TEXDOCVIEW)"; then
    echo ""
    echo "Those variables may make unexpected effect. Please unset."
    echo ""
    exit 1
fi

for f in "$HOME/texmf" "$HOME/.texmf-var" "$HOME/.texmf-config"; do
    if test -d "$f"; then
	echo ""
	echo "Personal texmf tree '$f' may make unexpected effect."
	echo "Please rename."
	echo ""
	exit 1
    fi
done

#PRINT_CFG=yes
. ./common.sh
root_check

MKTEMP=`mktemp ptexlive-tmp.XXXXXX`
if test $? -ne 0; then
    echo ""
    echo "We need 'mktemp' command."
    echo "Please visit http://www.mktemp.org/mktemp/."
    echo ""
    exit 1
fi
$RM $MKTEMP

uname -a
cat <<EOF

PATH="$PATH"

ISO_DIR="$ISO_DIR"
TEXLIVE_DIR="$TEXLIVE_DIR"
PREFIX="$PREFIX"

TMP_PREFIX="$TMP_PREFIX"
TEXSRC_EXTRACTED="$TEXSRC_EXTRACTED"
SRC_TAR="$SRC_TAR"
TEXMFDIST="$TEXMFDIST"

EXTRA_CMAP="$EXTRA_CMAP"
EXTRA_TRUETYPE="$EXTRA_TRUETYPE"
EXTRA_OPENTYPE="$EXTRA_OPENTYPE"

BASH="$BASH"
MAKE="$MAKE"
PATCH="$PATCH"
MD5="$MD5"
LZMA="$LZMA"
KANJI_CODE="$KANJI_CODE"
SYSTEM_NKF="$SYSTEM_NKF"
STRIP="$STRIP"

EOF
#CONF_OPTION="$CONF_OPTION"

echo "------------------------------------------------------------------------"

if test "$1" != "notexlive"; then
    CTAN=http://www.dnsbalance.ring.gr.jp/pub/text/CTAN/systems/texlive/Images
    if test "`grep '^texlive' \"$ISO_DIR/release-texlive.txt\"`" \
	!=  "texlive-20080822"; then
	cat <<-EOF

	Please get "texlive2008-20080822.iso.lzma" by following commands.
	wget $CTAN/texlive2008-20080822.iso.lzma

	EOF
	exit 1
    fi
    if test ! -d $TEXLIVE_DIR/tlpkg; then
	cat <<-EOF

	"tlpkg" directory is not found under $TEXLIVE_DIR.
	Check \$TEXLIVE_DIR in ptexlive.cfg.

	EOF
	exit 1
    fi
fi

test "$MD5" != "none" && necessity_command $MD5 < /dev/null
#necessity_command which which
necessity_command bash --version
necessity_command ed <<EOF
Q
EOF
necessity_command sed -e s/a/b/g $0
necessity_command egrep '^E?OF$' $0
necessity_command unzip -h
necessity_command gzip -h
#necessity_command bzip2 -h
test "$LZMA" == "lzmadec < " && necessity_command lzmadec --help
necessity_command perl -v
#necessity_command $MAKE -h
#necessity_command $PATCH

md5check <<EOF || exit
4628c724fdae722add87c0d7ab0da065  archive/dvipdfmx-20090502-bufferover.patch
72359ed39d3854489db9413b1b34c8ef  archive/dvipsk-5.97-p1.7b-tl.tar.gz
ab7f162c3707af7511d056f5950d9185  archive/jis.tar.gz
c82f9dbbe660149fc737e4f8dfb5095a  archive/jmpost-0.04b.tar.gz
cfbd4608916a6fe036075ed0d59ca11c  archive/makejvf-1.1a.tar.gz
f6aa95f9ee533d72eca85ba977b5c4cd  archive/mendexk2.6f.tar.gz
ef1bbc72d7dc89e42e88632471a82e7a  archive/morisawa.tar.gz
f19f48f2af8f520d6417d2177db54bfe  archive/nkf-2.0.9-autoconf.patch.gz
0dadcf178785c87874822a2ff8da9f19  archive/nkf-2.0.9.tar.gz
3ced255de713456bef1de85242999037  archive/omegaware-texlive2008.patch
4268d50a4b89cfb3d3ed767ac9b8c7bf  archive/patch-libs_lua51_lcoco_c
1b226893fb373f5e0a16bf9a4af35e9b  archive/patch-libs_lua51_lcoco_h
e4566ec1a195fd179a56b3f3deea0714  archive/ptex-src-3.1.11.tar.gz
9eb48ecb66cfd626865222564545de1c  archive/ptex-texmf-2.5.tar.gz
1613cfd336c8b2abc776370902b209e4  archive/ptexenc-1.0.6.tar.lzma
17bb6532041c61259cc64f59b325ad53  archive/tetex-3.0-dcb314.patch
ba9f5b90249a5385b8bc334c928f66d1  archive/updmap-cmsuper.patch
0174f407b35ab45e1c255f0f2af67c3f  archive/updmap-live2008-4b.diff
992043fb527052ad63279ac4490d99d3  archive/updmap-nostop.patch
47932deaff039788a43a1620753fdc1a  archive/web2c2009-getline.patch
06301b569854fa9ae5a61065cf69ac3d  archive/xdvik-20090903-texlive2008.diff.gz
c4e4abab05aa1b1873706efd1f6e7f8a  babel/babeltestJIS.tex
efd141cb33626b039f53e921070f9593  babel/japanese.zip
eab726afd7249145578df56daa3d805f  macro/jsclasses-090222.zip
4c6224bbdc50345999714c32958eb186  macro/otfstable-speedup.patch
0fd496d0e9b365457e161d18da9dfffb  macro/otfstable.zip
e36c6844920bb6c89384cc03fd8130a0  macro/sample.tex
f8a3ac31b14e6ae9484fe874e2d7c2a6  macro/utfsrc-speedup.patch
3461345204c3762e910d0fb7a8a890dd  macro/utfsrc.zip
525a1a163dab2a135fb38b6bf1510f4d  security/MOAB-06-01-2007.pdf
caab6b09d2d79aeb3d70383dc6059dcf  security/tetex-2.0.2-dvipdfm-security.patch
43911d0dae2ce667db8307d05e6f2a2d  security/tetex-3.0-CVE-2007-0455.patch
395fa10983cc124d9416410d15deeb4d  security/tetex-3.0-badscript.patch
ee58af50baa5af02d403b60bd82b330b  security/texlive2007-CVE-2007-3387.patch
EOF

echo ""
